﻿//
// ChibiMo3 Sample App
// Copyright (C) 2013  kuroi kouichi @ q61.org <ko@q61.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO.Ports;


namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            pictureBox1.AllowDrop = true;

            // init private vars
            _imgbuf = new ChibimoImageBuffer(ChibimoImageBuffer.LCDType.LS027B4DH01, 400, 240);
            _currentImage = null;

            // init combobox
            listComPorts();
            listComSpeeds();
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            // get data ready
            byte[] chibimocmd = _imgbuf.CreateChibimoCommandData();

            // open serial port
            try {
                string portname = (string)comboBox1.SelectedItem;
                int baudrate = _comspd[(string)comboBox2.SelectedItem];
                SerialPort port = new SerialPort(portname, baudrate);

                port.Open();
                port.Write(chibimocmd, 0, chibimocmd.Length);
                port.Close();
            } catch (Exception exception) {
                MessageBox.Show(exception.Message, "Send Data to Chibimo", MessageBoxButtons.OK);
            }
        }

        private void pictureBox1_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
                e.Effect = DragDropEffects.Copy;
            } else {
                e.Effect = DragDropEffects.None;
            }
        }

        private void pictureBox1_DragDrop(object sender, DragEventArgs e)
        {
            // read picture
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            Image img = Image.FromFile(files[0]);
            if (img != null) {
                // picture is OK, process it
                _currentImage = img;
                processImage();
            }
        }

        private void processImage()
        {
            if (_currentImage == null) return;

            this.Cursor = Cursors.WaitCursor;

            // if "scale to fit" is checked, scale image
            Image img = null;
            if (checkBox1.Checked) {
                double ratio_wd = 400.0 / _currentImage.Width;
                double ratio_ht = 240.0 / _currentImage.Height;
                double ratio = (ratio_wd < ratio_ht) ? ratio_wd : ratio_ht;

                img = new Bitmap(_currentImage, new Size((int)(_currentImage.Width * ratio),
                        (int)(_currentImage.Height * ratio)));
            } else {
                img = _currentImage;
            }

            // transfer image to buffer
            _imgbuf.SetDataFromImage(img);

            // if "floyd steinberg" is checked, apply it
            if (checkBox2.Checked) {
                _imgbuf.ApplyFloydSteinberg();
            }

            // show image
            pictureBox1.Image = _imgbuf.CreateImageFromContent();

            this.Cursor = Cursors.Default;
        }

        void listComPorts()
        {
            string[] comports = System.IO.Ports.SerialPort.GetPortNames();
            comboBox1.DataSource = comports;
        }

        void listComSpeeds()
        {
            _comspd = new Dictionary<string, int>();
            _comspd["9600bps"] = 9600;
            _comspd["500kbps"] = 500000;
            _comspd["1Mbps"] = 1000000;

            comboBox2.DataSource = _comspd.Keys.ToArray();
        }

        ChibimoImageBuffer _imgbuf;
        Image _currentImage;

        Dictionary<string, int> _comspd;


        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            this.processImage();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            this.processImage();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            string crep = _imgbuf.CreateCArrayRepresentation();
            if (crep != null) {
                Clipboard.SetText(crep);
                MessageBox.Show("Text copied to clipboard!");
            }
            this.Cursor = Cursors.Default;
        }
    }
}
